/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.world;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.util.properties.PropertiesParser;
import de.keksuccino.fancymenu.util.properties.PropertyContainer;
import de.keksuccino.fancymenu.util.properties.PropertyContainerSet;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LastWorldHandler {
    public static final File LAST_WORLD_SAVE_FILE = new File(FancyMenu.INSTANCE_DATA_DIR.getPath() + "/last_world.fmdata");
    protected static boolean isServer = false;
    @NotNull
    protected static String lastWorld = "";

    public static void init() {
        LastWorldHandler.readFile();
    }

    public static void setLastWorld(String world, boolean isServer) {
        if (world == null) {
            world = "";
        }
        lastWorld = world;
        LastWorldHandler.isServer = isServer;
        LastWorldHandler.writeFile();
    }

    @NotNull
    public static String getLastWorld() {
        return lastWorld;
    }

    public static boolean isLastWorldServer() {
        return isServer;
    }

    protected static void readFile() {
        try {
            List<PropertyContainer> secs;
            PropertyContainerSet set;
            if (!LAST_WORLD_SAVE_FILE.isFile()) {
                LastWorldHandler.writeFile();
            }
            if ((set = PropertiesParser.deserializeSetFromFile(LAST_WORLD_SAVE_FILE.getPath())) != null && !(secs = set.getContainersOfType("last_world")).isEmpty()) {
                String worldString;
                PropertyContainer sec = secs.get(0);
                String isServerString = sec.getValue("is_server");
                if (isServerString != null && isServerString.equals("true")) {
                    isServer = true;
                }
                if ((worldString = sec.getValue("world")) != null) {
                    lastWorld = worldString;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void writeFile() {
        try {
            if (!LAST_WORLD_SAVE_FILE.isFile()) {
                LAST_WORLD_SAVE_FILE.createNewFile();
            }
            PropertyContainerSet set = new PropertyContainerSet("last_world");
            PropertyContainer sec = new PropertyContainer("last_world");
            sec.putProperty("is_server", "" + isServer);
            sec.putProperty("world", lastWorld);
            set.putContainer(sec);
            PropertiesParser.serializeSetToFile(set, LAST_WORLD_SAVE_FILE.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

